<?php
    require_once('source/session.php');
    require_once('source/error.php');
    require_once('source/dbconfig.php');
    require_once('source/function.php');
    require_once('source/restrict_user.php');
    
    // At the top of main.php, ensure session is started and variables exist
    if(!isset($_SESSION['SESS_HASH_USER'])) {
        redirect('index.php');
    }

    // Get user data - UPDATED QUERY
    $rows = sql($DBH, "SELECT * FROM tbl_user WHERE hash = ?", array($_SESSION['SESS_HASH_USER']), "rows");
    foreach($rows as $row) {    
        $fullname = $row['fullname'];
        $profile_pic = $row['profile_pic'];
        $user_email = $row['email']; // This is the registration number
        $user_phone = $row['phone'];
        $user_class = $row['class'];
        $user_subclass = $row['subclass'];
        $user_age = $row['age'];
        $user_reg = $row['email']; // Using email field as registration number
    }
    
    if($_GET['msg'] == "refered"){
        $msg = "<div class='alert alert-success'>Referred successfully</div>";
    }else if($_GET['msg'] == "failed"){
        $msg = "<div class='alert alert-danger text-center'>Wrong Pin! Try again or buy a valid pin.</div>";
    }else if($_GET['msg'] == "sfailed"){
        $msg = "<div class='alert alert-danger text-center'>Wrong Pin! Someone else has already used this PIN</div>";
    }else if($_GET['msg'] == "PINfailed"){
        $msg = "<div class='alert alert-danger text-center'>Wrong Pin for this Result! You may have used this PIN for a different Session/Term</div>";
    }
    
    if($_SESSION['msg'] == "update") {
        $msg = "<div class='alert alert-success text-center'>Order Update Successful. Customer will receive email.<a class='btn btn-sm btn-outline-success' href='new_order.php'>Refresh</a></div>";
    }       
    
    // Calculate age - FIXED VERSION
    $age = 'N/A'; // Default value if age can't be calculated
    if (!empty($user_age)) {
        // Handle different date formats (mm/dd/yyyy or yyyy-mm-dd)
        if (strpos($user_age, '/') !== false) {
            // For dates in mm/dd/yyyy format
            $birthDate = explode("/", $user_age);
            $month = (int)$birthDate[0];
            $day = (int)$birthDate[1];
            $year = (int)$birthDate[2];
        } elseif (strpos($user_age, '-') !== false) {
            // For dates in yyyy-mm-dd format
            $birthDate = explode("-", $user_age);
            $year = (int)$birthDate[0];
            $month = (int)$birthDate[1];
            $day = (int)$birthDate[2];
        }
        
        // Calculate age if we have valid date components
        if (isset($year) && isset($month) && isset($day)) {
            $currentYear = date('Y');
            $currentMonth = date('m');
            $currentDay = date('d');

            $age = $currentYear - $year;
            
            if ($currentMonth < $month || ($currentMonth == $month && $currentDay < $day)) {
                $age--;
            }
        }
    }
    
        // Get last exam class - FIXED VERSION
    $last_exam_class = 'N/A'; // Default value
    $rows = sql($DBH, "SELECT class FROM tbl_student_results 
                      WHERE registration_no = ? 
                      ORDER BY id DESC LIMIT 1", 
              array($user_reg), "rows");
    
    if (!empty($rows)) {
        $last_exam_class = $rows[0]['class'];
    } elseif (!empty($user_class)) {
        // Fallback to user's current class if no exam records found
        $last_exam_class = $user_class;
    }
    
    // Profile picture handling
    if($profile_pic == "default") {
        $profile_image = "<img class='img-fluid rounded-circle profile-pic' width='120' src='profile_pic/profile.jpg'>";
    } else {
        $profile_image = "<img class='img-fluid rounded-circle profile-pic' width='120' src='../pri_admin/profile_pic/$profile_pic'>";
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verbum Dei Academy - Learners' Result Dashboard</title>
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome CDN -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&family=Playfair+Display:wght@700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #0d47a1;
            --secondary-color: #1976d2;
            --accent-color: #bbdefb;
            --dark-color: #002171;
            --light-color: #e3f2fd;
            --success-color: #2e7d32;
            --warning-color: #ff8f00;
            --danger-color: #c62828;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa;
            color: #333;
        }
        
        .header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 1.5rem 0;
            margin-bottom: 2rem;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        
        .school-name {
            font-family: 'Playfair Display', serif;
            font-weight: 700;
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        
        .school-motto {
            font-style: italic;
            opacity: 0.9;
            font-size: 0.9rem;
        }
        
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            margin-bottom: 1.5rem;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 16px rgba(0,0,0,0.1);
        }
        
        .card-header {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--primary-color) 100%);
            color: white;
            font-weight: 600;
            border-radius: 10px 10px 0 0 !important;
            padding: 1rem 1.5rem;
        }
        
        .profile-pic {
            border: 4px solid white;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        .student-name {
            font-size: 1.8rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 0.5rem;
        }
        
        .student-info-label {
            font-weight: 600;
            color: var(--dark-color);
        }
        
        .student-info-value {
            color: #555;
        }
        
        .form-control:focus {
            border-color: var(--secondary-color);
            box-shadow: 0 0 0 0.25rem rgba(25, 118, 210, 0.25);
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .btn-primary:hover {
            background-color: var(--dark-color);
            border-color: var(--dark-color);
        }
        
        .btn-check-result {
            background-color: var(--success-color);
            border-color: var(--success-color);
            font-weight: 600;
            padding: 0.5rem 1.5rem;
            font-size: 1.1rem;
        }
        
        .btn-check-result:hover {
            background-color: #1b5e20;
            border-color: #1b5e20;
        }
        
        .footer {
            background-color: var(--dark-color);
            color: white;
            padding: 1.5rem 0;
            margin-top: 2rem;
        }
        
        .nav-link {
            color: white;
            font-weight: 500;
        }
        
        .nav-link:hover {
            color: var(--accent-color);
        }
        
        .breadcrumb {
            background-color: white;
            border-radius: 8px;
            padding: 1rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .result-form-card {
            border-left: 4px solid var(--secondary-color);
        }
        
        @media print {
            .no-print {
                display: none !important;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header text-center">
        <div class="container">
            <div class="mb-2">
                <img src="vda_logo_pri.png" alt="Verbum Dei Academy" height="80" class="me-3">
            </div>
            <h1 class="school-name">Verbum Dei Academy</h1>
            <p class="school-motto">"Achieving Excellence Together"</p>
        </div>
    </div>

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
        <div class="container">
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="main.php">
                            <i class="fas fa-home me-2"></i> Learners' Result Dashboard
                        </a>
                    </li>
                </ul>
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php">
                            <i class="fas fa-sign-out-alt me-2"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container">
        <?php if (!empty($msg)) echo $msg; ?>
        
        <!-- Student Profile Card -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-md-2 text-center">
                        <?php echo $profile_image; ?>
                    </div>
                    <div class="col-md-10">
                        <h2 class="student-name"><?php echo htmlspecialchars($fullname); ?></h2>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <span class="student-info-label"><i class="fas fa-id-card me-2"></i> Admission No:</span>
                                <span class="student-info-value"><?php echo htmlspecialchars($user_reg); ?></span>
                            </div>
                            <div class="col-md-4 mb-3">
                                <span class="student-info-label"><i class="fas fa-child me-2"></i> Age:</span>
                                <span class="student-info-value"><?php echo $age; ?> years</span>
                            </div>
                        <!-- In the HTML section, update just the class display line: -->
                        <div class="col-md-4 mb-3">
                            <span class="student-info-label"><i class="fas fa-graduation-cap me-2"></i> Last Exam Class:</span><br>
                            <span class="student-info-value"><?php echo htmlspecialchars($last_exam_class); ?></span>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Result Checker Form -->
        <div class="card result-form-card">
            <div class="card-header">
                <i class="fas fa-poll me-2"></i> Result Checker
            </div>
            <div class="card-body">
                <form action="check_results.php" method="post" enctype="multipart/form-data" id="importFrm">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="registration_no" class="form-label student-info-label">
                                <i class="fas fa-id-card me-2"></i> Admission Number
                            </label>
                            <input type="text" class="form-control form-control-lg" id="registration_no" 
                                   name="registration_no" value="<?php echo htmlspecialchars($user_reg); ?>" 
                                   required readonly style="background-color: #e9f7fe;">
                        </div>
                        
                        <div class="col-md-6">
                            <label for="pin" class="form-label student-info-label">
                                <i class="fas fa-lock me-2"></i> Enter Student PIN
                            </label>
                            <input type="password" class="form-control form-control-lg" id="pin" 
                                   name="pin" placeholder="Enter your result PIN" required>
                        </div>
                        
                        <div class="col-md-4">
                            <label for="term" class="form-label student-info-label">
                                <i class="fas fa-calendar-alt me-2"></i> Choose Term
                            </label>
                            <select class="form-select form-select-lg" id="term" name="term" required>
                                <option value="">Select Term</option>
                                <option value="1st Term">1st Term</option>
                                <option value="2nd Term">2nd Term</option>
                                <option value="3rd Term">3rd Term</option>
                            </select>
                        </div>
                        
                        <div class="col-md-4">
                            <label for="mclass" class="form-label student-info-label">
                                <i class="fas fa-layer-group me-2"></i> Select Class
                            </label>
                            <select class="form-select form-select-lg" id="mclass" name="mclass" required>
                                <option value="">Select Class</option>
                                <?php
                                $rows1 = sql($DBH, "SELECT * FROM tbl_class where id >= ?", array(1), "rows");                            
                                foreach($rows1 as $row1) {    
                                    $sch_class = $row1['class'];
                                    echo "<option value='$sch_class'>$sch_class</option>";
                                }
                                ?>
                            </select>
                        </div>
                        
                        <div class="col-md-4">
                            <label for="year" class="form-label student-info-label">
                                <i class="fas fa-calendar me-2"></i> Academic Session
                            </label>
                            <select class="form-select form-select-lg" id="year" name="year" required>
                                <option value="">Select Session</option>
                                <?php
                                $rows1 = sql($DBH, "SELECT * FROM tbl_session where id >= ?", array(1), "rows");                            
                                foreach($rows1 as $row1) {    
                                    $sch_session = $row1['session'];
                                    echo "<option value='$sch_session'>$sch_session</option>";
                                }
                                ?>
                            </select>
                        </div>
                        
                        <div class="col-12 mt-4">
                            <button type="submit" class="btn btn-check-result btn-lg w-100" name="check" style="color:white">
                                <i class="fas fa-search me-2"></i> CHECK THIS RESULT
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer text-center">
        <div class="container">
            <div class="mb-2">
                <img src="vda_logo_pri.png" alt="Verbum Dei Academy" height="40" class="me-3">
            </div>
            <p class="mb-0">
                &copy; <?php echo date('Y'); ?> Verbum Dei Academy. All Rights Reserved.<br>
                <small>Learners' Result Portal</small>
            </p>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>