<?php
require_once('source/session.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Results On Hold - School Portal</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #7209b7;
            --warning-color: #f72585;
            --light-bg: #f8f9fa;
            --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px;
        }
        
        .hold-container {
            max-width: 600px;
            width: 100%;
            animation: fadeIn 0.8s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .hold-card {
            background: white;
            border-radius: 20px;
            box-shadow: var(--card-shadow);
            overflow: hidden;
            border: none;
        }
        
        .hold-header {
            background: linear-gradient(135deg, var(--warning-color), #b5179e);
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
        }
        
        .hold-icon {
            font-size: 5rem;
            margin-bottom: 20px;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        .hold-body {
            padding: 40px;
            text-align: center;
        }
        
        .hold-title {
            color: #d63384;
            font-weight: 700;
            margin-bottom: 20px;
            font-size: 1.8rem;
        }
        
        .hold-message {
            color: #666;
            font-size: 1.1rem;
            line-height: 1.6;
            margin-bottom: 30px;
        }
        
        .hold-details {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin: 25px 0;
            border-left: 4px solid var(--warning-color);
        }
        
        .hold-info-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        
        .hold-info-item:last-child {
            border-bottom: none;
        }
        
        .hold-info-label {
            font-weight: 600;
            color: #555;
        }
        
        .hold-info-value {
            color: #333;
        }
        
        .btn-back {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            border: none;
            padding: 14px 35px;
            border-radius: 50px;
            font-weight: 600;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(67, 97, 238, 0.3);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            text-decoration: none;
        }
        
        .btn-back:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(67, 97, 238, 0.4);
            color: white;
        }
        
        .support-info {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #777;
            font-size: 0.9rem;
        }
        
        .wave-decoration {
            height: 20px;
            background: url('data:image/svg+xml;utf8,<svg viewBox="0 0 1200 120" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><path d="M321.39,56.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,31,906.67,72,985.66,92.83c70.05,18.48,146.53,26.09,214.34,3V0H0V27.35A600.21,600.21,0,0,0,321.39,56.44Z" fill="%23ffffff"></path></svg>');
            background-size: 1200px 100%;
        }
        
        .countdown {
            font-size: 1.2rem;
            font-weight: 600;
            color: var(--warning-color);
            margin: 15px 0;
        }
        
        @media (max-width: 768px) {
            .hold-body {
                padding: 30px 20px;
            }
            
            .hold-header {
                padding: 25px 20px;
            }
            
            .hold-icon {
                font-size: 4rem;
            }
        }
    </style>
</head>
<body>
    <div class="hold-container">
        <div class="hold-card">
            <div class="hold-header">
                <div class="hold-icon">
                    <i class="fas fa-hourglass-half"></i>
                </div>
                <h1>Results Temporarily On Hold</h1>
            </div>
            
            <div class="wave-decoration"></div>
            
            <div class="hold-body">
                <h2 class="hold-title">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    Results Not Available
                </h2>
                
                <p class="hold-message">
                    Your examination results are currently being processed and are temporarily on hold. 
                    This may be due to pending administrative reviews, result compilation, or verification processes.
                </p>
                
                <!-- Auto-redirect countdown -->
                <div class="countdown" id="countdown">
                    Redirecting back in <span id="seconds">10</span> seconds...
                </div>
                
                <?php
                // Get parameters for display (if available)
                $studentName = isset($_SESSION['student_name']) ? $_SESSION['student_name'] : 'Student';
                $className = isset($_GET['class']) ? htmlspecialchars($_GET['class']) : (isset($_SESSION['class']) ? $_SESSION['class'] : 'N/A');
                $term = isset($_GET['term']) ? htmlspecialchars($_GET['term']) : (isset($_SESSION['term']) ? $_SESSION['term'] : 'N/A');
                $year = isset($_GET['year']) ? htmlspecialchars($_GET['year']) : (isset($_SESSION['year']) ? $_SESSION['year'] : 'N/A');
                ?>
                
                <div class="hold-details">
                    <div class="hold-info-item">
                        <span class="hold-info-label">Status:</span>
                        <span class="hold-info-value">
                            <span class="badge bg-danger">ON HOLD</span>
                        </span>
                    </div>
                    <div class="hold-info-item">
                        <span class="hold-info-label">Student:</span>
                        <span class="hold-info-value"><?php echo htmlspecialchars($studentName); ?></span>
                    </div>
                    <div class="hold-info-item">
                        <span class="hold-info-label">Class:</span>
                        <span class="hold-info-value"><?php echo htmlspecialchars($className); ?></span>
                    </div>
                    <div class="hold-info-item">
                        <span class="hold-info-label">Academic Year:</span>
                        <span class="hold-info-value"><?php echo htmlspecialchars($year); ?></span>
                    </div>
                    <div class="hold-info-item">
                        <span class="hold-info-label">Term:</span>
                        <span class="hold-info-value"><?php echo htmlspecialchars($term); ?></span>
                    </div>
                </div>
                
                <p class="hold-message">
                    Please check back later or contact your school administration for more information. 
                    Results will be made available as soon as the verification process is complete.
                </p>
                
                <a href="javascript:history.back()" class="btn-back" id="backButton">
                    <i class="fas fa-arrow-left"></i>
                    Back to Previous Page
                </a>
                
                <div class="support-info">
                    <i class="fas fa-info-circle me-1"></i>
                    For assistance, contact: schooladmin@example.com or call: (123) 456-7890
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Countdown for auto-redirect
        let seconds = 10;
        const countdownElement = document.getElementById('seconds');
        const countdownContainer = document.getElementById('countdown');
        
        const countdownInterval = setInterval(function() {
            seconds--;
            countdownElement.textContent = seconds;
            
            if (seconds <= 0) {
                clearInterval(countdownInterval);
                // Go back to previous page
                window.history.back();
            }
            
            // Change color when 5 seconds or less
            if (seconds <= 5) {
                countdownElement.style.color = '#dc3545';
                countdownElement.style.fontWeight = 'bold';
            }
        }, 1000);
        
        // Override the back button to clear interval
        document.getElementById('backButton').addEventListener('click', function() {
            clearInterval(countdownInterval);
        });
        
        // Also clear interval if user navigates away
        window.addEventListener('beforeunload', function() {
            clearInterval(countdownInterval);
        });
    </script>
</body>
</html>