<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');

// Initialize message variable
$msg = '';

// Check for various session messages
if (isset($_GET['msg'])) {
    switch ($_GET['msg']) {
        case "activated":
            $msg = "Email Verification is Successful!<br>Sign in to Your Dashboard";
            break;
        case "inactive":
            $msg = "Are you a new member? Check your email to activate your account Now! For a blocked participant, write to support.";
            break;
        case "duplicate":
            $msg = "Email already registered, please try another.";
            break;
        case "signup":
            $msg = "Account Registered successfully.";
            break;
        case "captcha":
            $msg = "Incorrect Captcha.";
            break;
        case "samp":
            $msg = "Samp request found, please try again.";
            break;
        case "failed":
            $msg = "Invalid Username/Password Combination.";
            break;
        case "forget":
            $msg = "<div class='alert alert-success'>New password has been sent to your verified email.</div>";
            break;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>VERBUM DEI INT'L COLLEGE CBT Admin Login</title>
    <link rel="icon" type="image/png" href="assets/images/coll_logo.jpg">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        body {
            background-color: #006400;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }
        
        .login-container {
            background-color: white;
            border-radius: 5px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 450px;
        }
        
        .login-header {
            background-color: black;
            color: yellow;
            padding: 15px;
            border-radius: 5px 5px 0 0;
            text-align: center;
            font-weight: bold;
        }
        
        .login-body {
            padding: 25px;
        }
        
        .btn-login {
            background-color: #A10A3F;
            border: 2px solid #006400;
            color: #B3D9FF;
            font-weight: bold;
            padding: 14px;
            width: 100%;
        }
        
        .btn-login:hover {
            background-color: #800020;
            color: white;
        }
        
        .powered-by {
            text-align: right;
            margin-top: 20px;
        }
        
        .powered-by img {
            border-radius: 50px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 text-center mb-4">
                <img src="assets/images/coll_logo.jpg" alt="School Logo" width="200">
            </div>
            
            <div class="col-md-6">
                <?php if (!empty($msg)): ?>
                    <div class="alert alert-warning alert-dismissible fade show mb-3">
                        <?= $msg ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                
                <div class="login-container">
                    <div class="login-header">
                        ADMIN LOGIN (CBT MGT.)<br>
                        <span style="color:white">[Sign In Here]</span>
                    </div>
                    
                    <div class="login-body">
                        <form method="post" action="exe_signin.php" autocomplete="off">
                            <div class="mb-3">
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                                    <input type="text" class="form-control" name="username" placeholder="Username or Email" required autofocus>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                    <input type="password" class="form-control" name="password" placeholder="Password" required>
                                </div>
                            </div>
                            
                            <div class="d-grid">
                                <button type="submit" name="signin" class="btn btn-login">
                                    <i class="fas fa-sign-in-alt me-2"></i> SIGN IN
                                </button>
                            </div>
                        </form>
                        
                        <div class="powered-by">
                            <a href="https://dataswift.com.ng" target="_blank">
                                <img src="assets/images/dataswift_logo.png" width="120" alt="DataSwift">
                                <div>Proudly Powered by <strong>DataSwift</strong></div>
                                <small style="color: #FF0000">For Support: +234-803-292-9756</small>
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="text-center mt-3 text-white">
                    <small>
                        <strong>Copyright © <?= date('Y') ?> VERBUM DEI INT'L COLLEGE</strong><br>
                        All Rights Reserved | Powered by DataSwift Portals
                    </small>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>