<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>VERBUM DEI INT'L COLLEGE CBT Management (Admin)</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --light-green: #e8f5e9;
            --primary-green: #2e7d32;
            --dark-green: #1b5e20;
            --accent-red: #A10A3F;
        }
        
        body {
            background-color: var(--light-green);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .admin-header {
            background-color: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .action-card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            height: 100%;
        }
        
        .action-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        
        .btn-exam {
            background-color: var(--primary-green);
            color: white;
        }
        
        .btn-questions {
            background-color: #1565C0;
            color: white;
        }
        
        .btn-results {
            background-color: #6A1B9A;
            color: white;
        }
        
        .btn-danger {
            background-color: var(--accent-red);
        }
        
        .card-icon {
            font-size: 2rem;
            margin-bottom: 1rem;
        }
        
        .img-fluid {
              width: 100px;
              height:100px;
            }

    </style>
</head>
<body>
    <!-- Header -->
    <header class="admin-header py-3">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <div class="logo-container me-3">
                        <img src="assets/images/coll_logo.jpg" alt="VDA COLLEGE Logo" class="img-fluid">
                    </div>
                    <div>
                        <h1 class="h4 mb-0">VERBUM DEI INT'L COLLEGE CBT Management</h1>
                        <small class="text-muted">Admin Dashboard</small>
                    </div>
                </div>
                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="adminDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-user-circle me-1"></i> <?= htmlspecialchars($_SESSION['SESS_FULLNAME_ADMIN']) ?>
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="adminDropdown">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-user me-2"></i> Profile</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-cog me-2"></i> Settings</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="../logout.php"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <div class="container py-4">
        <div class="row mb-4">
            <div class="col-12">
                <div class="card action-card">
                    <div class="card-body text-center">
                        <h3 class="card-title"><i class="fas fa-tachometer-alt me-2"></i> CBT Admin Dashboard</h3>
                        <p class="text-muted">Manage all computer-based test activities</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Exam Management Section -->
        <div class="row mb-4">
            <div class="col-12">
                <h4 class="mb-3"><i class="fas fa-book-open me-2"></i> Exam Management</h4>
            </div>
            
            <div class="col-md-4 mb-3">
                <div class="card action-card">
                    <div class="card-body text-center">
                        <i class="fas fa-plus-circle card-icon text-success"></i>
                        <h5>Create New Exam</h5>
                        <p class="text-muted">Set up a new examination</p>
                        <a href="create_exam.php" class="btn btn-exam btn-sm">
                            <i class="fas fa-plus me-1"></i> Create Exam
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4 mb-3">
                <div class="card action-card">
                    <div class="card-body text-center">
                        <i class="fas fa-users-class card-icon text-primary"></i>
                        <i class="fas fa-users card-icon text-primary"></i>
                        <h5>Assign Classes to Exams</h5>
                        <p class="text-muted">Manage exam access by class</p>
                        <a href="exam_class.php" class="btn btn-exam btn-sm">
                            <i class="fas fa-tasks me-1"></i> Assign Classes to Exams
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4 mb-3">
                <div class="card action-card">
                    <div class="card-body text-center">
                        <i class="fas fa-edit card-icon text-info"></i>
                        <h5>Add Subjects to Exams</h5>
                        <p class="text-muted">Add all Subjects of the Exam</p>
                        <a href="add_subject_to_exam.php" class="btn btn-exam btn-sm">
                            <i class="fas fa-list me-1"></i> Add Subjects
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Question Management Section -->
        <div class="row mb-4">
            <div class="col-12">
                <h4 class="mb-3"><i class="fas fa-question-circle me-2"></i> Question Management</h4>
            </div>
            
            <div class="col-md-4 mb-3">
                <div class="card action-card">
                    <div class="card-body text-center">
                        <i class="fas fa-plus-square card-icon text-success"></i>
                        <h5>Set New Questions</h5>
                        <p class="text-muted">Create new question sets</p>
                        <a href="set_questions.php" class="btn btn-questions btn-sm">
                            <i class="fas fa-plus me-1"></i> Add Questions
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4 mb-3">
                <div class="card action-card">
                    <div class="card-body text-center">
                        <i class="fas fa-layer-group card-icon text-primary"></i>
                        <h5>Add to Existing Question Sets</h5>
                        <p class="text-muted">Add More Questions to current question bank</p>
                        <a href="add_question.php" class="btn btn-questions btn-sm">
                            <i class="fas fa-plus-circle me-1"></i> Add More Questions
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4 mb-3">
                <div class="card action-card">
                    <div class="card-body text-center">
                        <i class="fas fa-edit card-icon text-warning"></i>
                        <h5>Edit/Delete Questions</h5>
                        <p class="text-muted">Modify existing questions</p>
                        <a href="manage_questions.php" class="btn btn-questions btn-sm">
                            <i class="fas fa-edit me-1"></i> Manage
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Results Section -->
        <div class="row">
            <div class="col-12">
                <h4 class="mb-3"><i class="fas fa-chart-bar me-2"></i> Results & Analysis</h4>
            </div>
            
            <div class="col-md-6 mb-3">
                <div class="card action-card">
                    <div class="card-body text-center">
                        <i class="fas fa-poll card-icon text-purple"></i>
                        <h5>View CBT Results</h5>
                        <p class="text-muted">Analyze student performance</p>
                        <a href="view_cbt_results.php" class="btn btn-results btn-sm">
                            <i class="fas fa-chart-pie me-1"></i> View Results
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6 mb-3">
                <div class="card action-card">
                    <div class="card-body text-center">
                        <i class="fas fa-file-export card-icon text-info"></i>
                        <h5>Export Results</h5>
                        <p class="text-muted">Download results in multiple formats</p>
                        <a href="export_results.php" class="btn btn-results btn-sm">
                            <i class="fas fa-download me-1"></i> Export Data
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer mt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <p class="mb-1">VERBUM DEI INT'L COLLEGE</p>
                    <p class="mb-0">Powered By <a href="https://dataswift.com.ng" target="_blank" class="text-white">DataSwift</a> 
                    <img src="assets/images/datalogo.png" alt="DataSwift Logo" style="height: 20px; margin-left: 5px;"></p>
                </div>
                <div class="col-md-4 text-md-end">
                    <p class="mb-0">&copy; <?= date('Y') ?> All Rights Reserved</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</body>
</html>