<?php
    require_once('source/session.php');
    require_once('source/error.php');
    require_once('source/dbconfig.php');
    require_once('source/function.php');
    require_once('source/restrict_user.php');
    session_start();    
    
    // Check if the user is logged in as a teacher
    if (isset($_SESSION['SESS_ID_TEACHER'])) {
        $userId = $_SESSION['SESS_ID_TEACHER'];

        // Fetch teacher details based on the ID from tbl_user
        $query = "SELECT * FROM tbl_user WHERE id = :id AND teacher = 'true'";
        $stmt = $DBH->prepare($query);
        $stmt->bindParam(':id', $userId, PDO::PARAM_INT);
        $stmt->execute();

        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $teacherName = $row['fullname'] ?? $row['username'] ?? 'Teacher';
            $teacherEmail = $row['email'] ?? '';
        }
    } else {
        // Redirect to login if not authenticated as teacher
        header("Location: index.php");
        exit();
    }
    
    if(isset($_GET['msg']) && $_GET['msg'] == "refered"){
        $msg = "<div class='alert alert-success mb-3'>Refered successfully</div>";
    } else if(isset($_GET['msg']) && $_GET['msg'] == "failed"){
        $msg = "<div class='alert alert-warning mb-3'>Something went wrong, please try again</div>";
    }
    
    if(isset($_SESSION['msg']) && $_SESSION['msg'] == "update") {
        $msg = "<div class='alert alert-success text-center mb-3'>Order Update Succesful. Customer will receive email.<a 
        class='btn-sm' href='new_order.php'>Refresh</a></div>";
    }       
    
    // Count students (teacher = false)
    $studentCount = $DBH->query("SELECT COUNT(*) FROM tbl_user WHERE teacher = 'false'")->fetchColumn();
    
    // Count results uploaded by this teacher
    $resultCount = $DBH->prepare("SELECT COUNT(DISTINCT CONCAT(registration_no, '-', term, '-', year)) FROM tbl_student_results WHERE teacher_no = :teacher_id");
    $resultCount->bindParam(':teacher_id', $userId, PDO::PARAM_INT);
    $resultCount->execute();
    $teacherResultCount = $resultCount->fetchColumn();
    
    // Count active sessions from tbl_session
    $sessionCount = $DBH->query("SELECT COUNT(DISTINCT session) FROM tbl_session")->fetchColumn();
    
    // Count classes assigned to this teacher (assuming there's a teacher_class table)
    // This is a placeholder - adjust based on your actual database structure
    $classCount = 0; // You'll need to implement this based on your schema
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>VERBUM DEI INT'L COLLEGE - Teacher Dashboard</title>
  <link rel="icon" type="image/png" href="https://portal.vda.com.ng/coll_admin/coll_logo.jpg">
  
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts - Nunito -->
  <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
  
  <!-- Custom CSS -->
  <style>
    :root {
      --primary-color: #1976d2;
      --secondary-color: #64b5f6;
      --accent-color: #bbdefb;
      --dark-color: #0d47a1;
      --light-color: #e3f2fd;
      --text-dark: #212529;
      --text-light: #f8f9fa;
      
      /* Group colors - Updated with more vibrant options */
      --group-1: #4caf50;
      --group-1-light: #e8f5e9;
      --group-2: #2196f3;
      --group-2-light: #e3f2fd;
      --group-3: #9c27b0;
      --group-3-light: #f3e5f5;
      --group-4: #ff9800;
      --group-4-light: #fff3e0;
      --group-5: #f44336;
      --group-5-light: #ffebee;
      --group-6: #607d8b;
      --group-6-light: #eceff1;
      --group-7: #009688;
      --group-7-light: #e0f2f1;
      --group-8: #673ab7;
      --group-8-light: #ede7f6;
      --group-9: #795548;
      --group-9-light: #efebe9;
      
      /* Stat card colors */
      --stat-1: #4caf50;
      --stat-2: #2196f3;
      --stat-3: #9c27b0;
      --stat-4: #ff9800;
      --stat-5: #f44336;
    }
    
    body {
      font-family: 'Nunito', sans-serif;
      background-color: #f5f7fa;
      padding-top: 56px;
      color: var(--text-dark);
    }
    
    /* Sidebar Styles */
    .sidebar {
      background: linear-gradient(180deg, var(--dark-color) 0%, var(--primary-color) 100%);
      position: fixed;
      top: 56px;
      left: 0;
      width: 250px;
      height: calc(100vh - 56px);
      transition: all 0.3s;
      z-index: 1000;
      overflow-y: auto;
    }
    
    .sidebar .nav-link {
      color: rgba(255, 255, 255, 0.85);
      font-weight: 600;
      padding: 0.75rem 1rem;
      margin-bottom: 0.2rem;
      transition: all 0.2s;
    }
    
    .sidebar .nav-link:hover {
      color: #fff;
      background-color: rgba(255, 255, 255, 0.15);
    }
    
    .sidebar .nav-link.active {
      color: #fff;
      background-color: var(--secondary-color);
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .sidebar .nav-link i {
      margin-right: 0.5rem;
      width: 20px;
      text-align: center;
    }
    
    /* Main Content Styles */
    .main-content {
      margin-left: 250px;
      width: calc(100% - 250px);
      transition: all 0.3s;
      min-height: calc(100vh - 56px);
      padding-bottom: 60px;
    }
    
    @media (max-width: 991.98px) {
      .sidebar {
        left: -250px;
      }
      .main-content {
        margin-left: 0;
        width: 100%;
      }
      body {
        padding-top: 56px;
      }
    }
    
    /* Compact layout */
    .dashboard-container {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 1rem;
      padding: 1rem;
    }
    
    .group-card {
      border-radius: 0.5rem;
      box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
      overflow: hidden;
      height: 100%;
      display: flex;
      flex-direction: column;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .group-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.15);
    }
    
    .group-header {
      padding: 0.75rem 1rem;
      color: white;
      font-weight: 600;
      display: flex;
      align-items: center;
      font-size: 0.95rem;
    }
    
    .group-header i {
      margin-right: 0.5rem;
      font-size: 1rem;
      color: white;
    }
    
    .group-body {
      padding: 0.75rem;
      background: white;
      flex-grow: 1;
      display: grid;
      grid-template-columns: 1fr;
      gap: 0.5rem;
    }
    
    .group-item {
      display: flex;
      align-items: center;
      padding: 0.5rem;
      border-radius: 0.25rem;
      transition: all 0.2s;
      color: var(--text-dark);
      text-decoration: none;
      font-size: 0.85rem;
    }
    
    /* Alternating background colors for group items */
    .group-card:nth-child(1) .group-item:nth-child(odd) { background-color: var(--group-1-light); }
    .group-card:nth-child(2) .group-item:nth-child(odd) { background-color: var(--group-2-light); }
    .group-card:nth-child(3) .group-item:nth-child(odd) { background-color: var(--group-3-light); }
    .group-card:nth-child(4) .group-item:nth-child(odd) { background-color: var(--group-4-light); }
    .group-card:nth-child(5) .group-item:nth-child(odd) { background-color: var(--group-5-light); }
    .group-card:nth-child(6) .group-item:nth-child(odd) { background-color: var(--group-6-light); }
    .group-card:nth-child(7) .group-item:nth-child(odd) { background-color: var(--group-7-light); }
    .group-card:nth-child(8) .group-item:nth-child(odd) { background-color: var(--group-8-light); }
    .group-card:nth-child(9) .group-item:nth-child(odd) { background-color: var(--group-9-light); }
    
    .group-item:hover {
      background-color: rgba(0,0,0,0.05) !important;
      transform: translateX(3px);
    }
    
    .group-item i {
      width: 20px;
      text-align: center;
      margin-right: 0.5rem;
      color: inherit;
      font-size: 0.9rem;
    }
    
    /* Navbar */
    .navbar {
      background-color: var(--primary-color);
      box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 37, 41, 0.1);
      position: fixed;
      top: 0;
      width: 100%;
      z-index: 1030;
      color: white;
    }
    
    /* Welcome banner */
    .welcome-banner {
      background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
      color: white;
      border-radius: 0.5rem;
      padding: 1rem;
      margin: 1rem;
      box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }
    
    /* Stats cards - Updated with colorful design */
    .stats-container {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
      gap: 1rem;
      margin: 0 1rem 1rem;
    }
    
    .stat-card {
      border-radius: 0.5rem;
      padding: 1rem;
      text-align: center;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      color: white;
      transition: transform 0.3s ease;
    }
    
    .stat-card:hover {
      transform: translateY(-3px);
    }
    
    .stat-card i {
      font-size: 1.5rem;
      margin-bottom: 0.5rem;
      color: white;
      background-color: rgba(255,255,255,0.2);
      width: 50px;
      height: 50px;
      line-height: 50px;
      border-radius: 50%;
      display: inline-block;
    }
    
    .stat-card h5 {
      font-size: 1.5rem;
      margin-bottom: 0.25rem;
      font-weight: 700;
    }
    
    .stat-card p {
      font-size: 0.9rem;
      margin-bottom: 0;
      opacity: 0.9;
    }
    
    /* Color assignments for stat cards */
    .stat-card:nth-child(1) { background: linear-gradient(135deg, var(--stat-1) 0%, #66bb6a 100%); }
    .stat-card:nth-child(2) { background: linear-gradient(135deg, var(--stat-2) 0%, #64b5f6 100%); }
    .stat-card:nth-child(3) { background: linear-gradient(135deg, var(--stat-3) 0%, #ba68c8 100%); }
    .stat-card:nth-child(4) { background: linear-gradient(135deg, var(--stat-4) 0%, #ffb74d 100%); }
    .stat-card:nth-child(5) { background: linear-gradient(135deg, var(--stat-5) 0%, #ef5350 100%); }
    
    /* Footer styles */
    .footer {
      background-color: var(--dark-color);
      color: white;
      padding: 15px 0;
      position: fixed;
      bottom: 0;
      width: 100%;
      z-index: 100;
    }
    
    .copyright-text {
      font-weight: 600;
      font-size: 0.85rem;
    }
    
    .powered-by {
      display: flex;
      align-items: center;
      justify-content: flex-end;
      color: white;
      font-size: 0.85rem;
    }
    
    .powered-by img {
      height: 20px;
      margin-left: 8px;
    }
    
    .powered-by-link {
      display: flex;
      align-items: center;
      text-decoration: none;
      color: inherit;
      transition: opacity 0.3s ease;
    }
    
    .powered-by-link:hover {
      opacity: 0.8;
      text-decoration: none;
    }
    
    /* Group header colors */
    .group-header.group-1 { background: linear-gradient(135deg, var(--group-1) 0%, #66bb6a 100%); }
    .group-header.group-2 { background: linear-gradient(135deg, var(--group-2) 0%, #64b5f6 100%); }
    .group-header.group-3 { background: linear-gradient(135deg, var(--group-3) 0%, #ba68c8 100%); }
    .group-header.group-4 { background: linear-gradient(135deg, var(--group-4) 0%, #ffb74d 100%); }
    .group-header.group-5 { background: linear-gradient(135deg, var(--group-5) 0%, #ef5350 100%); }
    .group-header.group-6 { background: linear-gradient(135deg, var(--group-6) 0%, #90a4ae 100%); }
    .group-header.group-7 { background: linear-gradient(135deg, var(--group-7) 0%, #4db6ac 100%); }
    .group-header.group-8 { background: linear-gradient(135deg, var(--group-8) 0%, #9575cd 100%); }
    .group-header.group-9 { background: linear-gradient(135deg, var(--group-9) 0%, #a1887f 100%); }
    
    /* Card icons color */
    .group-card:nth-child(1) .group-item i { color: var(--group-1); }
    .group-card:nth-child(2) .group-item i { color: var(--group-2); }
    .group-card:nth-child(3) .group-item i { color: var(--group-3); }
    .group-card:nth-child(4) .group-item i { color: var(--group-4); }
    .group-card:nth-child(5) .group-item i { color: var(--group-5); }
    .group-card:nth-child(6) .group-item i { color: var(--group-6); }
    .group-card:nth-child(7) .group-item i { color: var(--group-7); }
    .group-card:nth-child(8) .group-item i { color: var(--group-8); }
    .group-card:nth-child(9) .group-item i { color: var(--group-9); }
    
    /* Profile dropdown */
    .dropdown-menu {
      border: none;
      box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }
    
    .dropdown-item:hover {
      background-color: var(--light-color);
    }
  </style>
</head>

<body>
  <!-- Top Navigation -->
  <nav class="navbar navbar-expand-lg navbar-light">
    <div class="container-fluid">
      <button id="sidebarToggle" class="btn btn-link d-lg-none me-2">
        <i class="fas fa-bars"></i>
      </button>
      <a class="navbar-brand d-none d-lg-block" href="#">
        VERBUM DEI INT'L COLLEGE
      </a>
      <div class="ms-auto d-flex align-items-center">
        <div class="dropdown">
          <button class="btn btn-link text-white dropdown-toggle d-flex align-items-center" type="button" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="fas fa-user-circle me-2"></i>
            <span class="admin-name"><?php echo htmlspecialchars($teacherName); ?></span>
          </button>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown">
            <li><a class="dropdown-item" href="edit_profile.php"><i class="fas fa-user-edit me-2"></i>Edit Profile</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a></li>
          </ul>
        </div>
      </div>
    </div>
  </nav>

  <!-- Sidebar -->
  <nav id="sidebar" class="sidebar">
    <div class="position-sticky pt-3">
      <div class="text-center mb-4 d-none d-lg-block">
        <img src="https://portal.vda.com.ng/coll_admin/coll_logo.jpg" alt="School Logo" class="rounded-circle" width="80">
        <h5 class="mt-2 text-white">VERBUM DEI INT'L COLLEGE</h5>
        <p class="text-white-50 small">Teacher Dashboard</p>
      </div>
      
      <ul class="nav flex-column">
        <li class="nav-item">
          <a class="nav-link active" href="main.php">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            Teacher Dashboard
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="download_broadsheet.php">
            <i class="fas fa-fw fa-file-pdf"></i>
            Download Broadsheet
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="upload_results.php">
            <i class="fas fa-fw fa-upload"></i>
            Upload Tests & Exams
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="upload_attendance.php">
            <i class="fas fa-fw fa-calendar-check"></i>
            Upload Attendance
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="upload_skills.php">
            <i class="fas fa-fw fa-chart-bar"></i>
            Upload Skills & Psychomotor
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="https://portal.vda.com.ng" target="_blank">
            <i class="fas fa-fw fa-external-link-alt"></i>
            Go to Main School Portal
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="logout.php">
            <i class="fas fa-fw fa-sign-out-alt"></i>
            Logout
          </a>
        </li>
      </ul>
    </div>
  </nav>

  <!-- Main Content -->
  <main class="main-content">
    <!-- Welcome Banner -->
    <div class="welcome-banner">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <h4>Welcome back, <?php echo htmlspecialchars($teacherName); ?>!</h4>
          <p class="mb-0">Verbum Dei Int'l College Teacher Dashboard</p>
        </div>
        <div class="d-none d-sm-inline-block">
          <span class="badge bg-white text-primary p-2">
            <i class="fas fa-phone-alt me-1"></i> Support: MENDOH - 08032929756
          </span>
        </div>
      </div>
    </div>

    <?php if(isset($msg)) { echo $msg; } ?>

    <!-- Quick Stats Section -->
    <div class="stats-container">
      <div class="stat-card">
        <i class="fas fa-users"></i>
        <h5><?php echo number_format($studentCount); ?></h5>
        <p>Total Students</p>
      </div>
      
      <div class="stat-card">
        <i class="fas fa-poll"></i>
        <h5><?php echo number_format($teacherResultCount); ?></h5>
        <p>My Result Records</p>
      </div>
      
      <div class="stat-card">
        <i class="fas fa-calendar-alt"></i>
        <h5><?php echo number_format($sessionCount); ?></h5>
        <p>Academic Sessions</p>
      </div>
      
      <div class="stat-card">
        <i class="fas fa-chalkboard"></i>
        <h5><?php echo number_format($classCount); ?></h5>
        <p>My Classes</p>
      </div>
    </div>

    <!-- Dashboard Groups -->
    <div class="dashboard-container">
      <!-- 1. Lesson Plans -->
      <div class="group-card">
        <div class="group-header group-1">
          <i class="fas fa-tasks"></i>
          <span>Manage Lesson Plans</span>
        </div>
        <div class="group-body">
          <a href="lesson_plan/create_lesson_plan.php" class="group-item">
            <i class="fas fa-plus-circle"></i>
            <span>Create Lesson Plan</span>
          </a>
          <a href="lesson_plan/view_lesson_plans.php" class="group-item">
            <i class="fas fa-eye"></i>
            <span>View Lesson Plans</span>
          </a>
          <a href="lesson_plan/edit_lesson_plans.php" class="group-item">
            <i class="fas fa-edit"></i>
            <span>Edit Lesson Plans</span>
          </a>
        </div>
      </div>

      <!-- 2. Tests & Exams -->
      <div class="group-card">
        <div class="group-header group-2">
          <i class="fas fa-upload"></i>
          <span>Upload Tests & Exams</span>
        </div>
        <div class="group-body">
          <a href="upload_results.php" class="group-item">
            <i class="fas fa-file-upload"></i>
            <span>Upload Results</span>
          </a>
          <a href="https://bkms.com.ng/portal/coll_admin/SAMPLE_CA1_CA2_EXAM.csv" class="group-item">
            <i class="fas fa-download"></i>
            <span>Download Template</span>
          </a>
          <a href="uploaded_results.php" class="group-item">
            <i class="fas fa-list"></i>
            <span>View Uploaded Results</span>
          </a>
        </div>
      </div>

      <!-- 3. Broadsheets -->
      <div class="group-card">
        <div class="group-header group-3">
          <i class="fas fa-file-pdf"></i>
          <span>Download Broadsheets</span>
        </div>
        <div class="group-body">
          <a href="download_broadsheet.php" class="group-item">
            <i class="fas fa-download"></i>
            <span>Download Broadsheet</span>
          </a>
          <a href="preview_broadsheet.php" class="group-item">
            <i class="fas fa-eye"></i>
            <span>Preview Broadsheet</span>
          </a>
          <a href="print_broadsheet.php" class="group-item">
            <i class="fas fa-print"></i>
            <span>Print Broadsheet</span>
          </a>
        </div>
      </div>

      <!-- 4. Attendance -->
      <div class="group-card">
        <div class="group-header group-4">
          <i class="fas fa-calendar-check"></i>
          <span>Upload Attendance</span>
        </div>
        <div class="group-body">
          <a href="upload_attendance.php" class="group-item">
            <i class="fas fa-upload"></i>
            <span>Upload Attendance</span>
          </a>
          <a href="attendance_template.php" class="group-item">
            <i class="fas fa-download"></i>
            <span>Download Att. Template</span>
          </a>
          <a href="view_attendance.php" class="group-item">
            <i class="fas fa-list"></i>
            <span>View Attendance</span>
          </a>
        </div>
      </div>

      <!-- 5. Skills & Psychomotor -->
      <div class="group-card">
        <div class="group-header group-5">
          <i class="fas fa-chart-bar"></i>
          <span>Upload Skills & Psychomotor</span>
        </div>
        <div class="group-body">
          <a href="upload_skills.php" class="group-item">
            <i class="fas fa-upload"></i>
            <span>Upload Skills</span>
          </a>
          <a href="https://bkms.com.ng/portal/coll_admin/SAMPLE_PSYCHOMOTOR_AND_OTHER_SKILLS.csv" class="group-item">
            <i class="fas fa-download"></i>
            <span>Download Skills Template</span>
          </a>
          <a href="view_skills.php" class="group-item">
            <i class="fas fa-list"></i>
            <span>View Skills Records</span>
          </a>
        </div>
      </div>

      <!-- 6. CBT Questions -->
      <div class="group-card">
        <div class="group-header group-6">
          <i class="fas fa-laptop-code"></i>
          <span>CBT Questions - Term Exams</span>
        </div>
        <div class="group-body">
          <a href="cbt/set_questions.php" class="group-item">
            <i class="fas fa-plus"></i>
            <span>Set Term Exams Questions</span>
          </a>
          <a href="cbt/add_question.php" class="group-item">
            <i class="fas fa-edit"></i>
            <span>Update Term Exams Questions</span>
          </a>
        </div>
      </div>

      <!-- 7. CBT Questions - Tests -->
      <div class="group-card">
        <div class="group-header group-7">
          <i class="fas fa-laptop"></i>
          <span>CBT Questions - Term Tests</span>
        </div>
        <div class="group-body">
          <a href="cbt/set_test_questions.php" class="group-item">
            <i class="fas fa-plus"></i>
            <span>Set Term Test Questions</span>
          </a>
          <a href="cbt/update_test_questions.php" class="group-item">
            <i class="fas fa-edit"></i>
            <span>Update Term Test Questions</span>
          </a>
        </div>
      </div>

      <!-- 8. Sample Sheets -->
      <div class="group-card">
        <div class="group-header group-8">
          <i class="fas fa-file-download"></i>
          <span>Download Sample Sheets</span>
        </div>
        <div class="group-body">
          <a href="https://bkms.com.ng/portal/coll_admin/SAMPLE_CA1_CA2_EXAM.csv" class="group-item">
            <i class="fas fa-download"></i>
            <span>Sample Test/Exam Entry Sheet</span>
          </a>
          <a href="https://bkms.com.ng/portal/coll_admin/SAMPLE_ATTENDANCE_SHEETS.csv" class="group-item">
            <i class="fas fa-download"></i>
            <span>Sample Attendance Entry Sheet</span>
          </a>
          <a href="https://bkms.com.ng/portal/coll_admin/SAMPLE_PSYCHOMOTOR_AND_OTHER_SKILLS.csv" class="group-item">
            <i class="fas fa-download"></i>
            <span>Sample Skills & Psychomotor Sheet</span>
          </a>
        </div>
      </div>

      <!-- 9. Assignments -->
      <div class="group-card">
        <div class="group-header group-9">
          <i class="fas fa-tasks"></i>
          <span>Manage Assignments</span>
        </div>
        <div class="group-body">
          <a href="assignments.php" class="group-item">
            <i class="fas fa-book-open"></i>
            <span>Manage Assignments</span>
          </a>
          <a href="create_assignment.php" class="group-item">
            <i class="fas fa-plus"></i>
            <span>Create Assignment</span>
          </a>
          <a href="view_assignments.php" class="group-item">
            <i class="fas fa-eye"></i>
            <span>View Assignments</span>
          </a>
        </div>
      </div>
    </div>

    <!-- Uploaded Results Section (Teacher's own results only) -->
    <div class="card m-3">
      <div class="card-header bg-primary text-white">
        <h6 class="mb-0"><i class="fas fa-calendar-alt me-2"></i>My Uploaded Results by Session</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <?php
          // Query to get results uploaded by this teacher only
          $STH = $DBH->prepare("SELECT COUNT(*) FROM tbl_student_results WHERE teacher_no = ?");
          $result = $STH->execute(array($userId));
          $count = $STH->fetchColumn();
          
          if($count >= 1) {
            $rows = sql($DBH, "SELECT MIN(id) AS id, year FROM tbl_student_results WHERE teacher_no = ? GROUP BY year", 
            array($userId), "rows");
            foreach($rows as $row) {  
              $t_year = $row['year'];
              echo '
              <div class="col-md-3 mb-3">
                <a href="main_term.php?year='.$t_year.'&teacher_id='.$userId.'" target="_blank" class="btn btn-outline-primary w-100">
                  <i class="fas fa-calendar-alt me-1"></i> '.$t_year.'
                </a>
              </div>';
            }
          } else {
            echo '<div class="col-12 text-center py-4">
              <i class="fas fa-info-circle fa-2x mb-3 text-muted"></i>
              <p class="text-muted">No results uploaded yet</p>
            </div>';
          }
          ?>
        </div>
      </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="footer">
    <div class="container-fluid">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="copyright-text">Copyright &copy; VERBUM DEI INT'L COLLEGE <?php echo date("Y"); ?></span>
        </div>
        <div class="col-md-6">
          <div class="powered-by">
            <a href="https://dataswift.com.ng" target="_blank" rel="noopener noreferrer" class="powered-by-link">
              <span>Powered by DataSwift</span>
              <img src="datalogo.png" alt="DataSwift Logo">
            </a>
          </div>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap 5 JS Bundle with Popper -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <!-- Custom Scripts -->
  <script>
    // Toggle sidebar on mobile
    document.getElementById('sidebarToggle').addEventListener('click', function() {
      document.getElementById('sidebar').classList.toggle('active');
      document.querySelector('.main-content').classList.toggle('active');
    });
    
    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(event) {
      const sidebar = document.getElementById('sidebar');
      const sidebarToggle = document.getElementById('sidebarToggle');
      
      if (window.innerWidth < 992 && 
          !sidebar.contains(event.target) && 
          !sidebarToggle.contains(event.target) && 
          sidebar.classList.contains('active')) {
        sidebar.classList.remove('active');
        document.querySelector('.main-content').classList.remove('active');
      }
    });
  </script>
</body>
</html>