<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig3.php'); // Include your new database connect
require_once('source/function.php');
require_once('source/restrict_admin.php');

// Fetch lesson plans from the database
function getLessonPlans()
{
    global $db;
    $stmt = $db->prepare("SELECT * FROM tbl_lessonplan");
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result) {
        $lessonPlans = array();
        while ($row = $result->fetch_assoc()) {
            $lessonPlans[] = $row;
        }
        return $lessonPlans;
    } else {
        return array(); // Return an empty array or handle the error accordingly
    }
}

// Fetch dynamic data for form elements
$lessonPlans = getLessonPlans();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lesson Plan List</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1200px;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        h2 {
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        table, th, td {
            border: 1px solid #ddd;
        }

        th, td {
            padding: 12px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        a {
            color: #007bff;
            text-decoration: none;
        }

        a:hover {
            text-decoration: underline;
        }
        
                .links {
            margin-bottom: 20px;
        }

        .links a {
            display: inline-block;
            margin-right: 15px;
            text-decoration: none;
            color: #007bff;
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>Lesson Plan List</h2>

        <!-- Add links with Font Awesome icons -->
        <center><div class="links">
            <a href="upload_lesson_plan.php"><i class="fas fa-upload"></i> Upload Lesson Plan</a>
            <a href="edit_lesson_plan.php"><i class="fas fa-edit"></i> Edit Your Descriptions</a>
            <a href="../index.php"><i class="fas fa-arrow-left"></i> Back to Admin Dashboard</a>
            <a href="https://smt.lahs.com.ng"><i class="fas fa-school"></i> Go to School Management</a>
        </div></center>


        <?php include('source/error_success_messages.php'); ?>

        <table>
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Lesson Plan Creator</th>
                    <th>Class</th>
                    <th>Subject</th>
                    <th>Lesson Date</th> 
                    <th>File Path</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($lessonPlans as $lessonPlan) : ?>
                    <tr>
                        <td><?php echo $lessonPlan['title']; ?></td>
                        <td><?php echo $lessonPlan['description']; ?></td>
                        <td><?php echo $lessonPlan['created_by']; ?></td>
                        <td><?php echo $lessonPlan['class']; ?></td>
                        <td><?php echo $lessonPlan['subject']; ?></td>
                        <td><?php echo $lessonPlan['lesson_date']; ?></td>
                        <td><a href="<?php echo $lessonPlan['file_path']; ?>" target="_blank">Get Lesson Plan</a></td>                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>

</html>
