<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');

// Message handling
$msg = '';
if(isset($_GET['msg'])) {
    $messages = [
        "refered" => "Referred successfully",
        "failed" => "Something went wrong, please try again",
        "deleted" => "Admin deleted successfully",
        "activated" => "Admin status updated successfully"
    ];
    
    if(isset($messages[$_GET['msg']])) {
        $alert_type = ($_GET['msg'] == "refered" || $_GET['msg'] == "deleted" || $_GET['msg'] == "activated") ? "success" : "danger";
        $msg = "<div class='alert alert-$alert_type text-center mb-4'>".$messages[$_GET['msg']]."</div>";
    }
}

// Get admin full name
$admin_fullname = '';
$rows = sql($DBH, "SELECT fullname FROM tbl_admin WHERE status = ?", ["Active"], "rows");
if(!empty($rows)) {
    $admin_fullname = $rows[0]['fullname'];
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Manage Admins - VERBUM DEI INT'L COLLEGE</title>
  <link rel="icon" type="image/png" href="https://portal.vda.com.ng/coll_admin/coll_logo.jpg">
  
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  
  <!-- Custom CSS -->
  <style>
    :root {
      --primary-blue: #1976d2;
      --dark-blue: #0d47a1;
      --light-blue: #64b5f6;
      --accent-blue: #bbdefb;
      --bg-light: #e3f2fd;
      --text-dark: #212529;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: var(--bg-light);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }
    
    /* Navbar Styles */
    .navbar {
      background-color: var(--primary-blue);
      box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 37, 41, 0.1);
      position: fixed;
      top: 0;
      width: 100%;
      z-index: 1030;
      color: white;
    }
    
    .navbar-brand {
      font-weight: 800;
      font-size: 1.2rem;
      color: white;
    }
    
    /* Sidebar Styles */
    .sidebar {
      background: linear-gradient(180deg, var(--dark-blue) 0%, var(--primary-blue) 100%);
      position: fixed;
      top: 56px;
      left: -250px;
      width: 250px;
      height: calc(100vh - 56px);
      transition: all 0.3s;
      z-index: 1000;
      overflow-y: auto;
    }
    
    .sidebar.active {
      left: 0;
    }
    
    .sidebar .nav-link {
      color: rgba(255, 255, 255, 0.85);
      font-weight: 600;
      padding: 0.75rem 1rem;
      margin-bottom: 0.2rem;
      transition: all 0.2s;
    }
    
    .sidebar .nav-link:hover {
      color: #fff;
      background-color: rgba(255, 255, 255, 0.15);
    }
    
    .sidebar .nav-link.active {
      color: #fff;
      background-color: var(--light-blue);
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .sidebar .nav-link i {
      margin-right: 0.5rem;
      width: 20px;
      text-align: center;
    }
    
    /* Main Content Styles */
    .main-content {
      margin-left: 0;
      width: 100%;
      transition: all 0.3s;
      flex: 1 0 auto;
      padding-top: 56px;
    }
    
    @media (min-width: 992px) {
      .sidebar {
        left: 0;
      }
      .main-content {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    /* Card Styles */
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
      margin-bottom: 1.5rem;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 1rem 2rem rgba(0, 0, 0, 0.15);
    }
    
    .card-header {
      background-color: var(--accent-blue);
      border-bottom: 1px solid var(--light-blue);
      font-weight: 700;
      color: var(--dark-blue);
      padding: 1rem 1.5rem;
    }
    
    /* Button Styles */
    .btn-primary {
      background-color: var(--primary-blue);
      border-color: var(--primary-blue);
      padding: 0.5rem 1.5rem;
      font-weight: 600;
    }
    
    .btn-primary:hover {
      background-color: var(--dark-blue);
      border-color: var(--dark-blue);
    }
    
    /* Status badges */
    .status-badge {
      padding: 0.35rem 0.65rem;
      border-radius: 50rem;
      font-weight: 600;
    }
    
    .status-badge-active {
      background-color: #28a745;
      color: white;
    }
    
    .status-badge-inactive {
      background-color: #dc3545;
      color: white;
    }
    
    /* Table Styles */
    .table-responsive {
      overflow-x: auto;
    }
    
    .table-hover tbody tr:hover {
      background-color: rgba(0, 0, 0, 0.03);
    }
    
    /* Action buttons */
    .action-btn {
      min-width: 100px;
      margin-bottom: 0.5rem;
    }
    
    /* Admin Info Styles */
    .admin-info {
      display: flex;
      align-items: center;
      background-color: rgba(255,255,255,0.2);
      padding: 8px 12px;
      border-radius: 8px;
      color: white;
    }
    
    .admin-name {
      margin-right: 5px;
      font-weight: 600;
    }
    
    .admin-access {
      font-style: italic;
      opacity: 0.8;
      margin-right: 10px;
      font-size: 0.9rem;
    }
    
    .admin-icon {
      font-size: 1.5rem;
      color: white;
    }
    
    /* Footer styles */
    .footer {
      background-color: var(--dark-blue);
      color: white;
      padding: 20px 0;
      flex-shrink: 0;
      width: 100%;
    }
    
    @media (min-width: 992px) {
      .footer {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    .copyright-text {
      font-weight: 600;
      font-size: 1rem;
    }
    
    /* Support badge */
    .support-badge {
      background-color: var(--accent-blue);
      color: var(--dark-blue);
      font-weight: 600;
      padding: 0.5rem 1rem;
    }
    
    /* Breadcrumbs */
    .breadcrumb-custom .breadcrumb {
      background-color: transparent;
      padding: 0;
    }
    
    .breadcrumb-custom .breadcrumb-item a {
      color: var(--primary-blue);
      text-decoration: none;
    }
    
    .breadcrumb-custom .breadcrumb-item.active {
      color: var(--dark-blue);
      font-weight: 500;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
      .card-body {
        padding: 1.5rem;
      }
      
      .admin-info {
        padding: 6px 10px;
      }
      
      .admin-name, .admin-access {
        font-size: 0.8rem;
      }
    }
  </style>
</head>

<body>
  <!-- Top Navigation -->
  <nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container-fluid">
      <button id="sidebarToggle" class="btn btn-link d-lg-none me-2">
        <i class="fas fa-bars"></i>
      </button>
      <a class="navbar-brand d-none d-lg-block" href="#">
        VERBUM DEI INT'L COLLEGE
      </a>
      <div class="ms-auto d-flex align-items-center">
        <div class="admin-info me-3">
          <span class="admin-name"><?php echo htmlspecialchars($admin_fullname); ?></span>
          <span class="admin-access">(Administrator)</span>
          <i class="fas fa-user-circle admin-icon"></i>
        </div>
        <a href="logout.php" class="btn btn-sm btn-outline-light">
          <i class="fas fa-sign-out-alt"></i>
        </a>
      </div>
    </div>
  </nav>

  <!-- Sidebar -->
  <nav id="sidebar" class="sidebar">
    <div class="position-sticky pt-3">
      <div class="text-center mb-4 d-none d-lg-block">
        <img src="https://portal.vda.com.ng/coll_admin/coll_logo.jpg" alt="School Logo" class="rounded-circle" width="80">
        <h5 class="mt-2 text-white">VERBUM DEI INT'L COLLEGE</h5>
        <p class="text-white-50 small">Admin Dashboard</p>
      </div>
      
      <ul class="nav flex-column">
        <li class="nav-item">
          <a class="nav-link" href="main.php">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            Admin Centre
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link active" href="list_admin.php">
            <i class="fas fa-fw fa-users-cog"></i>
            Manage Admins
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_session.php">
            <i class="fas fa-fw fa-calendar-alt"></i>
            School Year/Session
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_classes.php">
            <i class="fas fa-fw fa-building"></i>
            Manage Classes
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="add_students.php">
            <i class="fas fa-fw fa-user-plus"></i>
            Register New Student
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_subjects.php">
            <i class="fas fa-fw fa-book"></i>
            Create Subjects
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="teachers.php">
            <i class="fas fa-fw fa-chalkboard-teacher"></i>
            Manage Teachers
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="students.php">
            <i class="fas fa-fw fa-users"></i>
            Manage Students
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="deactivate_students.php">
            <i class="fas fa-fw fa-user-lock"></i>
            Activate/Deactivate
          </a>
        </li>
      </ul>
    </div>
  </nav>

  <!-- Main Content -->
  <main class="main-content">
    <div class="container-fluid px-4 pt-4">
      <!-- Page Heading -->
      <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Admin Management</h1>
        <div class="d-none d-sm-inline-block">
          <span class="badge support-badge p-2">
            <i class="fas fa-phone-alt me-1"></i> Support: 08032929756
          </span>
        </div>
      </div>

      <!-- Messages -->
      <?php echo $msg; ?>

      <!-- Breadcrumbs -->
      <div class="breadcrumb-custom mb-4">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="main.php">Admin Dashboard</a></li>
            <li class="breadcrumb-item active">Manage Admins</li>
          </ol>
        </nav>
      </div>

      <!-- Add Admin Button and Search -->
      <div class="d-flex justify-content-between mb-4">
        <a href="add_admin.php" class="btn btn-primary">
          <i class="fas fa-user-plus me-2"></i>Add New Admin
        </a>
        
        <form method="get" class="d-flex">
          <div class="input-group">
            <input type="text" class="form-control" name="search" placeholder="Search admins..." 
                   value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>">
            <button class="btn btn-outline-secondary" type="submit">
              <i class="fas fa-search"></i>
            </button>
            <?php if(isset($_GET['search'])): ?>
            <a href="list_admin.php" class="btn btn-outline-danger">
              <i class="fas fa-times"></i>
            </a>
            <?php endif; ?>
          </div>
        </form>
      </div>

      <!-- Admins Table -->
      <div class="card shadow mb-4">
        <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold">Admin List</h6>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-hover">
              <thead class="table-light">
                <tr>
                  <th>ID</th>
                  <th>Username</th>
                  <th>Email</th>
                  <th>Registration Date</th>
                  <th>Status</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php
                // Get search term if exists
                $search = isset($_GET['search']) ? strip_tags($_GET['search']) : '';
                
                // Fetch admins based on search
                if(!empty($search)) {
                    $rows = sql($DBH, "SELECT * FROM tbl_admin WHERE (username LIKE ? OR email LIKE ?)", 
                              ["%".$search."%", "%".$search."%"], "rows");
                } else {
                    $rows = sql($DBH, "SELECT * FROM tbl_admin ORDER BY id DESC", [], "rows");
                }

                if(empty($rows)): ?>
                <tr>
                  <td colspan="6" class="text-center py-4">
                    <i class="fas fa-user-shield fa-2x mb-3 text-muted"></i>
                    <p class="text-muted">No admins found</p>
                    <a href="add_admin.php" class="btn btn-primary">
                      <i class="fas fa-user-plus me-2"></i>Add New Admin
                    </a>
                  </td>
                </tr>
                <?php else: 
                foreach($rows as $row): 
                    $admin_id = $row['id'];
                    $admin_username = htmlspecialchars($row['username']);
                    $admin_email = htmlspecialchars($row['email']);
                    $admin_reg_date = $row['registration_date'];
                    $admin_status = $row['status'];
                    $admin_hash = $row['hash'];
                    
                    $status_badge = ($admin_status == "Active") 
                        ? "<span class='status-badge status-badge-active'>Active</span>" 
                        : "<span class='status-badge status-badge-inactive'>Inactive</span>";
                    
                    $status_link = ($admin_status == "Active")
                        ? "<a href='settings.php?approve_admin=$admin_hash' class='btn btn-warning btn-sm action-btn'>
                             <i class='fas fa-user-lock me-1'></i>Deactivate
                           </a>"
                        : "<a href='settings.php?approve_admin=$admin_hash' class='btn btn-success btn-sm action-btn'>
                             <i class='fas fa-user-check me-1'></i>Activate
                           </a>";
                ?>
                <tr>
                  <td><?php echo $admin_id; ?></td>
                  <td><?php echo $admin_username; ?></td>
                  <td><?php echo $admin_email; ?></td>
                  <td><?php echo $admin_reg_date; ?></td>
                  <td><?php echo $status_badge; ?></td>
                  <td>
                    <div class="d-grid gap-2">
                      <a href='edit_admin.php?admin_id=<?php echo $admin_id; ?>' class='btn btn-primary btn-sm action-btn'>
                        <i class='fas fa-edit me-1'></i>Edit
                      </a>
                      <button class='btn btn-danger btn-sm action-btn' onclick="confirmDelete(<?php echo $admin_id; ?>)">
                        <i class='fas fa-trash me-1'></i>Delete
                      </button>
                    </div>
                  </td>
                </tr>
                <?php endforeach; 
                endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="footer">
    <div class="container-fluid">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="copyright-text">Copyright &copy; VERBUM DEI INT'L COLLEGE <?php echo date("Y"); ?></span>
        </div>
        <div class="col-md-6">
          <div class="text-md-end">
            <a href="https://dataswift.com.ng" target="_blank" rel="noopener noreferrer" class="text-white">
              <span>Powered by DataSwift</span>
              <img src="datalogo.png" alt="DataSwift Logo" class="ms-2" height="24">
            </a>
          </div>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap 5 JS Bundle with Popper -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  
  <!-- Custom Scripts -->
  <script>
    // Toggle sidebar on mobile
    document.getElementById('sidebarToggle').addEventListener('click', function() {
        document.getElementById('sidebar').classList.toggle('active');
        document.querySelector('.main-content').classList.toggle('active');
    });
    
    // Confirm admin deletion
    function confirmDelete(adminId) {
        if (confirm("Are you sure you want to delete this admin?")) {
            window.location.href = `settings.php?delete_admin=${adminId}`;
        }
    }
  </script>
</body>
</html>