<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');

if($_GET['msg'] == "refered"){
    $msg = "<div class='alert alert-success text-center mb-4'>Refered successfully</div>";
}else if($_GET['msg'] == "failed"){
    $msg = "<div class='alert alert-warning text-center mb-4'>Something went wrong, please try again</div>";
}

if($_SESSION['msg'] == "update") {
    $msg = "<div class='alert alert-success text-center mb-4'>Order Update Succesful. Customer will receive email.<a class='btn btn-sm btn-outline-light ml-2' href='new_order.php'>Refresh</a></div>";
}       

$rows1 = sql($DBH, "SELECT * FROM tbl_student_results where csv_no = ?", 
array($_GET['val']), "rows");
foreach($rows1 as $row1) {	
    $u_name = $row1['name'];
    $u_registration_no = $row1['registration_no'];
    $u_test = $row1['test'];
    $u_home_work = $row1['home_work'];
    $u_project = $row1['project'];
    $u_exam = $row1['exam'];
    
    $total = ($u_test + $u_home_work + $u_project + $u_exam);

    sql($DBH, "UPDATE tbl_student_results set total = ?, teacher_no = ? WHERE registration_no =? AND test = ?", array($total,$_GET['hsh'],$u_registration_no,$u_test));
    
    $rows2 = sql($DBH, "SELECT * FROM tbl_student_results where csv_no = ? ORDER by (total) desc", 
    array($_GET['val']), "rows");
    $sno = 0;
    foreach($rows2 as $row2) {	
        $sno++;
        $us_name = $row2['name'];
        $us_registration_no = $row2['registration_no'];
        $us_test = $row2['test'];
        $us_home_work = $row2['home_work'];
        $us_project = $row2['project'];
        $us_exam = $row2['exam'];
        $us_total = $row2['total'];
        $us_class = $row2['class'];
        $us_year = $row2['year'];
        $us_term = $row2['term'];
        
        if($us_total <=39){
            $grade = "Poor";
        }
        else if ($us_total >39 && $us_total<= 49) {
            $grade = "Fair";
        }
        else if ($us_total >49 && $us_total<= 59) {
            $grade = "Credit";
        }
        else if ($us_total >59 && $us_total<= 69) {
            $grade = "Good";
        }
        else if ($us_total >69 && $us_total<= 79) {
            $grade = "Very Good";
        }
        else if ($us_total >79 && $us_total<= 100) {
            $grade = "Excellent";
        }
        
        sql($DBH, "UPDATE tbl_student_results set grade = ?, position = ? WHERE registration_no =? AND test = ?", array($grade,$sno,$us_registration_no,$us_test));
    }
}

//Overall
$STH = $DBH->prepare("SELECT count(*) FROM tbl_overall WHERE class = ? AND year = ? AND term = ? ");
$result = $STH->execute(array($_GET['stclass'],$_GET['year'],$_GET['stterm']));
$cnt_overall = $STH->fetchColumn();
if($cnt_overall == 0){
    $rows1 = sql($DBH, "SELECT * FROM tbl_student_results WHERE class = ? AND year = ? AND term = ?", array($_GET['stclass'],$_GET['year'],$_GET['stterm']), "rows");
    foreach($rows1 as $row1) {	
        $st_registration_no = $row1['registration_no'];
        $st_class = $row1['class'];
        $st_name = $row1['name'];
                                 
        $b_in_s = sql($DBH, "SELECT SUM(total) FROM tbl_student_results WHERE class = ? AND year = ? AND term = ? AND registration_no = ?", array($_GET['stclass'],$_GET['year'],$_GET['stterm'],$st_registration_no), "rows");			
        foreach($b_in_s as $b_in_row){	
            $b_ins = $b_in_row[0];
        }
        
        sql($DBH, "insert into tbl_overall (name, reg_no, class, year, term, overall) values (?,?,?,?,?,?)", array($st_name,$st_registration_no,$_GET['stclass'],$_GET['year'],$_GET['stterm'],$b_ins));	
        
        $rows2 = sql($DBH, "SELECT * FROM tbl_overall WHERE class = ? AND year = ? AND term = ? ORDER by (overall) desc", 
        array($_GET['stclass'],$_GET['year'],$_GET['stterm']), "rows");
        $snum = 0;
        foreach($rows2 as $row2) {	
            $snum++;
            $ust_name = $row2['name'];
            $ust_reg_no = $row2['reg_no'];
            $ust_test = $row2['test'];	
            
            sql($DBH, "UPDATE tbl_overall set position = ? WHERE class = ? AND year = ? AND term = ? AND reg_no = ?", array($snum,$_GET['stclass'],$_GET['year'],$_GET['stterm'],$ust_reg_no), "rows");
        }
    }	
} else if($cnt_overall > 0){
    $rows2 = sql($DBH, "SELECT * FROM tbl_overall WHERE class = ? AND year = ? AND term = ? ORDER by (overall) desc", 
    array($_GET['stclass'],$_GET['year'],$_GET['stterm']), "rows");
    $snum = 0;
    foreach($rows2 as $row2) {	
        $snum++;
        $ust_name = $row2['name'];
        $ust_reg_no = $row2['reg_no'];
        $ust_test = $row2['test'];	
                                 
        $b_in_s = sql($DBH, "SELECT SUM(total) FROM tbl_student_results WHERE class = ? AND year = ? AND term = ? AND registration_no = ?", array($_GET['stclass'],$_GET['year'],$_GET['stterm'],$ust_reg_no), "rows");			
        foreach($b_in_s as $b_in_row){	
            $b_ins = $b_in_row[0];
        }
        
        sql($DBH, "UPDATE tbl_overall set overall = ? WHERE class = ? AND year = ? AND term = ? AND reg_no = ?", array($b_ins,$_GET['stclass'],$_GET['year'],$_GET['stterm'],$ust_reg_no), "rows");
        sql($DBH, "UPDATE tbl_overall set position = ? WHERE class = ? AND year = ? AND term = ? AND reg_no = ?", array($snum,$_GET['stclass'],$_GET['year'],$_GET['stterm'],$ust_reg_no), "rows");
    }
}

// Get admin full name
$admin_fullname = '';
$rows = sql($DBH, "SELECT fullname FROM tbl_admin WHERE status = ?", ["Active"], "rows");
if(!empty($rows)) {
    $admin_fullname = $rows[0]['fullname'];
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Manage Results - VERBUM DEI INT'L COLLEGE</title>
  <link rel="icon" type="image/png" href="https://portal.vda.com.ng/coll_admin/coll_logo.jpg">
  
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  
  <!-- Custom CSS -->
  <style>
    :root {
      --primary-blue: #1976d2;
      --dark-blue: #0d47a1;
      --light-blue: #64b5f6;
      --accent-blue: #bbdefb;
      --bg-light: #e3f2fd;
      --text-dark: #212529;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: var(--bg-light);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }
    
    /* Navbar Styles */
    .navbar {
      background-color: var(--primary-blue);
      box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 37, 41, 0.1);
      position: fixed;
      top: 0;
      width: 100%;
      z-index: 1030;
      color: white;
    }
    
    .navbar-brand {
      font-weight: 800;
      font-size: 1.2rem;
      color: white;
    }
    
    /* Sidebar Styles */
    .sidebar {
      background: linear-gradient(180deg, var(--dark-blue) 0%, var(--primary-blue) 100%);
      position: fixed;
      top: 56px;
      left: -250px;
      width: 250px;
      height: calc(100vh - 56px);
      transition: all 0.3s;
      z-index: 1000;
      overflow-y: auto;
    }
    
    .sidebar.active {
      left: 0;
    }
    
    .sidebar .nav-link {
      color: rgba(255, 255, 255, 0.85);
      font-weight: 600;
      padding: 0.75rem 1rem;
      margin-bottom: 0.2rem;
      transition: all 0.2s;
    }
    
    .sidebar .nav-link:hover {
      color: #fff;
      background-color: rgba(255, 255, 255, 0.15);
    }
    
    .sidebar .nav-link.active {
      color: #fff;
      background-color: var(--light-blue);
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .sidebar .nav-link i {
      margin-right: 0.5rem;
      width: 20px;
      text-align: center;
    }
    
    /* Main Content Styles */
    .main-content {
      margin-left: 0;
      width: 100%;
      transition: all 0.3s;
      flex: 1 0 auto;
      padding-top: 56px;
    }
    
    @media (min-width: 992px) {
      .sidebar {
        left: 0;
      }
      .main-content {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    /* Card Styles */
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
      margin-bottom: 1.5rem;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 1rem 2rem rgba(0, 0, 0, 0.15);
    }
    
    .card-header {
      background-color: var(--accent-blue);
      border-bottom: 1px solid var(--light-blue);
      font-weight: 700;
      color: var(--dark-blue);
      padding: 1rem 1.5rem;
    }
    
    /* Button Styles */
    .btn-primary {
      background-color: var(--primary-blue);
      border-color: var(--primary-blue);
      padding: 0.5rem 1.5rem;
      font-weight: 600;
    }
    
    .btn-primary:hover {
      background-color: var(--dark-blue);
      border-color: var(--dark-blue);
    }
    
    /* Form Styles */
    .form-control, .form-select {
      height: 50px;
      border-radius: 8px;
      padding: 0.5rem 1rem;
      border: 1px solid #ced4da;
      transition: all 0.3s;
    }
    
    .form-control:focus, .form-select:focus {
      border-color: var(--light-blue);
      box-shadow: 0 0 0 0.25rem rgba(100, 181, 246, 0.25);
    }
    
    /* Admin Info Styles */
    .admin-info {
      display: flex;
      align-items: center;
      background-color: rgba(255,255,255,0.2);
      padding: 8px 12px;
      border-radius: 8px;
      color: white;
    }
    
    .admin-name {
      margin-right: 5px;
      font-weight: 600;
    }
    
    .admin-access {
      font-style: italic;
      opacity: 0.8;
      margin-right: 10px;
      font-size: 0.9rem;
    }
    
    .admin-icon {
      font-size: 1.5rem;
      color: white;
    }
    
    /* Footer styles */
    .footer {
      background-color: var(--dark-blue);
      color: white;
      padding: 20px 0;
      flex-shrink: 0;
      width: 100%;
    }
    
    @media (min-width: 992px) {
      .footer {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    .copyright-text {
      font-weight: 600;
      font-size: 1rem;
    }
    
    /* Support badge */
    .support-badge {
      background-color: var(--accent-blue);
      color: var(--dark-blue);
      font-weight: 600;
      padding: 0.5rem 1rem;
    }
    
    /* Warning text */
    .warning-text {
      color: #dc3545;
      font-weight: 600;
    }
    
    /* Access key highlight */
    .access-key {
      font-weight: 700;
      color: var(--primary-blue);
      background-color: var(--accent-blue);
      padding: 0.2rem 0.5rem;
      border-radius: 4px;
    }
    
    /* Result Folder Styles */
    .result-folder {
      width: 200px;
      transition: all 0.2s ease;
      border-left: 4px solid var(--primary-blue);
      background: white;
      padding: 15px;
      margin: 10px;
      border-radius: 0.5rem;
      box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
    }
    
    .result-folder:hover {
      transform: translateY(-3px);
      box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.15);
    }
    
    .folder-container {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      padding: 15px;
      background-color: var(--bg-light);
      border-radius: 0.5rem;
    }
    
    /* Breadcrumbs */
    .breadcrumb-custom .breadcrumb {
      background-color: transparent;
      padding: 0;
    }
    
    .breadcrumb-custom .breadcrumb-item a {
      color: var(--primary-blue);
      text-decoration: none;
    }
    
    .breadcrumb-custom .breadcrumb-item.active {
      color: var(--dark-blue);
      font-weight: 500;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
      .card-body {
        padding: 1.5rem;
      }
      
      .admin-info {
        padding: 6px 10px;
      }
      
      .admin-name, .admin-access {
        font-size: 0.8rem;
      }
      
      .result-folder {
        width: 100%;
        margin: 5px 0;
      }
    }
  </style>
</head>

<body>
  <!-- Top Navigation -->
  <nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container-fluid">
      <button id="sidebarToggle" class="btn btn-link d-lg-none me-2">
        <i class="fas fa-bars"></i>
      </button>
      <a class="navbar-brand d-none d-lg-block" href="#">
        VERBUM DEI INT'L COLLEGE
      </a>
      <div class="ms-auto d-flex align-items-center">
        <div class="admin-info me-3">
          <span class="admin-name"><?php echo htmlspecialchars($admin_fullname); ?></span>
          <span class="admin-access">(Administrator)</span>
          <i class="fas fa-user-circle admin-icon"></i>
        </div>
        <a href="logout.php" class="btn btn-sm btn-outline-light">
          <i class="fas fa-sign-out-alt"></i>
        </a>
      </div>
    </div>
  </nav>

  <!-- Sidebar -->
  <nav id="sidebar" class="sidebar">
    <div class="position-sticky pt-3">
      <div class="text-center mb-4 d-none d-lg-block">
        <img src="https://portal.vda.com.ng/coll_admin/coll_logo.jpg" alt="School Logo" class="rounded-circle" width="80">
        <h5 class="mt-2 text-white">VERBUM DEI INT'L COLLEGE</h5>
        <p class="text-white-50 small">Admin Dashboard</p>
      </div>
      
      <ul class="nav flex-column">
        <li class="nav-item">
          <a class="nav-link" href="main.php">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            Admin Centre
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_session.php">
            <i class="fas fa-fw fa-calendar-alt"></i>
            School Year/Session
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_classes.php">
            <i class="fas fa-fw fa-building"></i>
            Manage Classes
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="add_students.php">
            <i class="fas fa-fw fa-user-plus"></i>
            Register New Student
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_subjects.php">
            <i class="fas fa-fw fa-book"></i>
            Create Subjects
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="teachers.php">
            <i class="fas fa-fw fa-chalkboard-teacher"></i>
            Manage Teachers
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="students.php">
            <i class="fas fa-fw fa-users"></i>
            Manage Students
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="deactivate_students.php">
            <i class="fas fa-fw fa-user-lock"></i>
            Activate/Deactivate
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link active" href="upload_results.php">
            <i class="fas fa-fw fa-upload"></i>
            Upload Results
          </a>
        </li>
      </ul>
    </div>
  </nav>

  <!-- Main Content -->
  <main class="main-content">
    <div class="container-fluid px-4 pt-4">
      <!-- Page Heading -->
      <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manage Student Results</h1>
        <div class="d-none d-sm-inline-block">
          <span class="badge support-badge p-2">
            <i class="fas fa-phone-alt me-1"></i> Support: 08032929756
          </span>
        </div>
      </div>

      <!-- Messages -->
      <?php if (!empty($msg)) echo $msg; ?>

      <!-- Breadcrumbs -->
      <div class="breadcrumb-custom mb-4">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="main.php">Admin Dashboard</a></li>
            <li class="breadcrumb-item active">Result Management</li>
          </ol>
        </nav>
      </div>

      <!-- Result Folders Section -->
      <div class="card shadow mb-4">
        <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold">Result Sheet</h6>
        </div>
        <div class="card-body">
          <div class="folder-container">
            <?php
            // Get distinct terms for the selected year
            $terms = sql($DBH, 
                "SELECT DISTINCT term FROM tbl_student_results WHERE year = ? ORDER BY term", 
                [$_GET['id']], 
                "rows"
            );
            
            if(!empty($terms)) {
                foreach($terms as $term) {
                    $term_name = $term['term'];
                    $year = $_GET['id'];
                    
                    echo '
                    <div class="result-folder text-center">
                      <a href="main_class.php?id='.htmlspecialchars($term_name).'&examyear='.htmlspecialchars($year).'" target="_blank" class="btn btn-primary w-100">
                        <i class="fas fa-folder-open me-2"></i> '.htmlspecialchars($term_name).'
                      </a>
                    </div>';
                }
            } else {
                echo '<div class="alert alert-info w-100">No results found for the selected year.</div>';
            }
            ?>
          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="footer">
    <div class="container-fluid">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="copyright-text">Copyright &copy; VERBUM DEI INT'L COLLEGE <?php echo date("Y"); ?></span>
        </div>
        <div class="col-md-6">
          <div class="text-md-end">
            <a href="https://dataswift.com.ng" target="_blank" rel="noopener noreferrer" class="text-white">
              <span>Powered by DataSwift</span>
              <img src="datalogo.png" alt="DataSwift Logo" class="ms-2" height="24">
            </a>
          </div>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap 5 JS Bundle with Popper -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  
  <!-- Custom Scripts -->
  <script>
    // Toggle sidebar on mobile
    document.getElementById('sidebarToggle').addEventListener('click', function() {
        document.getElementById('sidebar').classList.toggle('active');
        document.querySelector('.main-content').classList.toggle('active');
    });
  </script>
</body>
</html>